% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creators.R
\name{create_question}
\alias{create_question}
\alias{create_question_raw}
\title{Create a quiz question}
\usage{
create_question(
  prompt,
  ...,
  type = c("auto", "single", "multiple"),
  input = c("auto", "select", "checkbox"),
  shuffle = FALSE,
  ns = shiny::NS("quiz")
)

create_question_raw(
  prompt,
  grader,
  correct_answer_pretty,
  user_answer_prettifier = function(user_input) paste0(user_input, collapse = ", ")
)
}
\arguments{
\item{prompt}{Text of the question prompt. Can also be an HTML element such as \code{\link[htmltools:builder]{htmltools::div()}}.}

\item{...}{Objects of class 'quizChoice' generated from \code{\link[=add_choice]{add_choice()}}, \code{\link[=add_numeric]{add_numeric()}}, \code{\link[=add_slider]{add_slider()}}, or \code{\link[=add_text]{add_text()}}. Named options to \code{\link[shiny:selectInput]{shiny::selectInput()}} or \code{\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput()}} can be passed as well.}

\item{type}{One of c('auto', 'single', 'multiple'). Can the user select only one answer or multiple?}

\item{input}{One of c('auto', 'select', 'checkbox'). Should the UI for a select object created by \code{\link[shiny:selectInput]{shiny::selectInput()}} or checkbox by \code{\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput()}}?}

\item{shuffle}{TRUE or FALSE. If TRUE order of choices will be randomly shuffled.}

\item{ns}{Namespace function generated from \code{\link[shiny:NS]{shiny::NS()}}}

\item{grader}{A function that takes the user answer and determines if it is correct. Must take one argument and return TRUE or FALSE. This is wrapped with \code{\link[purrr:possibly]{purrr::possibly()}} and \code{\link[base:Logic]{base::isTRUE()}} to catch any errors.}

\item{correct_answer_pretty}{A string representing the correct answer that is printed 'pretty'}

\item{user_answer_prettifier}{A function with one argument that takes the user's answers and prints it 'pretty'}
}
\value{
an object of class \code{quizQuestion}

an object of class \code{quizQuestion}
}
\description{
Create a single quiz question. Used in conjunction with \code{\link[=create_quiz]{create_quiz()}} to generate a quiz.
}
\details{
\code{create_question} is the default method of creating quiz questions.

\code{create_question_raw()} allows any HTML in the \code{prompt}. This must contain a shiny input that is accessible via \code{input$answers}. The namespace also needs care. The default \code{inputId} is \code{shiny::NS('quiz')('answers')}.
}
\section{Functions}{
\itemize{
\item \code{create_question()}: Create a quiz question

\item \code{create_question_raw()}: Create a quiz question using custom inputs. This is a more flexible function that allows any html.

}}
\examples{
q <- create_question(
  prompt = 'My prompt explaining what the ATE of this thing should be',
  add_choice("34"),
  add_choice("59", TRUE),
  add_choice("98", TRUE)
)

q2 <- create_question(
  prompt = 'My prompt explaining what the ATC of this thing should be',
  add_slider(0, 30, 15, correct = 10)
 )
quiz <- create_quiz(q, q2)
q3 <- create_question_raw(
  prompt = htmltools::div(
    htmltools::p("my question"),
    shiny::selectInput(
      inputId = shiny::NS('quiz')('answers'),
      label = 'Select 5',
      choices = c(4, 5, 6)
    )
 ),
 grader = \(user_input) user_input == '5',
 correct_answer_pretty = '5'
)
quiz2 <- create_quiz(q3, q2)
}
\seealso{
\code{\link[=add_choice]{add_choice()}}, \code{\link[=add_slider]{add_slider()}}, \code{\link[=add_numeric]{add_numeric()}}, \code{\link[=add_text]{add_text()}}, \code{\link[=create_question_raw]{create_question_raw()}}
}
\author{
Joseph Marlo, George Perrett

Joseph Marlo
}
