% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRT.R
\name{mpirt}
\alias{mpirt}
\title{Compute expected probability for multiple items}
\usage{
mpirt(item_par, theta)
}
\arguments{
\item{item_par}{\code{data.frame}, dataframe with nrows equal to the number of items and 4 columns, one for each of the item parameters. The columns must be named "a", "b", "c", "e" and must contain the respective IRT parameters, namely discrimination \eqn{a_i}, location \eqn{b_i}, pseudo-guessing \eqn{c_i}, and upper asymptote \eqn{e_i}.}

\item{theta}{\code{numeric} latent trait level of person \eqn{p}, it can be a single value or a vector of values.}
}
\value{
A \eqn{p \times i} matrix of class \code{mpirt} with the expected probability of observing a correct response for respondent \eqn{p} on item \eqn{i}
}
\description{
Compute expected probability for multiple items
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
expected_prob <- mpirt(item_par, theta)
}
