% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doublesigmoidalFitFunctions_h0.R
\name{doublesigmoidalFitFunction_h0}
\alias{doublesigmoidalFitFunction_h0}
\title{Double sigmoidal fit function with h0.}
\usage{
doublesigmoidalFitFunction_h0(
  dataInput,
  tryCounter,
  startList = list(finalAsymptoteIntensityRatio = 0, maximum = 1, slope1Param = 1,
    midPoint1Param = 0.33, slope2Param = 1, midPointDistanceParam = 0.29, h0 = 0.1),
  lowerBounds = c(finalAsymptoteIntensityRatio = 0, maximum = 0.3, slope1Param = 0.01,
    midPoint1Param = -0.52, slope2Param = 0.01, midPointDistanceParam = 0.04, h0 = 0),
  upperBounds = c(finalAsymptoteIntensityRatio = 1, maximum = 1.5, slope1Param = 180,
    midPoint1Param = 1.15, slope2Param = 180, midPointDistanceParam = 0.63, h0 = 0.3),
  min_Factor = 1/2^20,
  n_iterations = 1000
)
}
\arguments{
\item{dataInput}{A dataframe or a list containing the dataframe. The dataframe should be composed of at least two columns. One represents time, and the other represents intensity. The data should be normalized with the normalize data function sicegar::normalizeData() before being imported into this function.}

\item{tryCounter}{A counter that shows the number of times the data was fit via maximum likelihood function.}

\item{startList}{The vector containing the initial set of parameters that algorithm tries for the first fit attempt for the relevant parameters. The vector composes of seven elements; 'finalAsymptoteIntensityRatio', 'maximum', 'slope1Param', 'midPoint1Param' , 'slope2Param', 'midPointDistanceParam', and 'h0'. Detailed explanations of those parameters can be found in vignettes. Defaults are  finalAsymptoteIntensityRatio = 0, maximum = 1, slope1Param = 1, midPoint1Param = 0.33, slope2Param = 1, midPointDistanceParam=0.29, and h0 = 0. The numbers are in normalized time intensity scale.}

\item{lowerBounds}{The lower bounds for the randomly generated start parameters. The vector is composed of seven elements; 'finalAsymptoteIntensityRatio', 'maximum', 'slope1Param', 'midPoint1Param' , 'slope2Param', 'midPointDistanceParam', and 'h0'. Detailed explanations of those parameters can be found in vignettes. Defaults are finalAsymptoteIntensityRatio = 0, maximum = 0.3, slope1Param = .01, midPoint1Param = -0.52, slope2Param = .01, midPointDistanceParam = 0.04, and h0 = -0.1. The numbers are in normalized time intensity scale.}

\item{upperBounds}{The upper bounds for the randomly generated start parameters. The vector is composed of seven elements; 'finalAsymptoteIntensityRatio', 'maximum', 'slope1Param', 'midPoint1Param' , 'slope2Param', 'midPointDistanceParam', and 'h0'. Detailed explanations of those parameters can be found in vignettes. Defaults are finalAsymptoteIntensityRatio = 1, maximum = 1.5, slope1Param = 180, midPoint1Param = 1.15, slope2Param = 180, midPointDistanceParam = 0.63, and h0 = 0.3. The numbers are in normalized time intensity scale.}

\item{min_Factor}{Defines the minimum step size used by the fitting algorithm. Default is 1/2^20.}

\item{n_iterations}{Defines maximum number of iterations used by the fitting algorithm. Default is 1000.}
}
\value{
Returns the fitted parameters and goodness of fit metrics.
}
\description{
The function fits a double sigmoidal curve to given data by using likelihood maximization (LM) algorithm and provides the parameters (maximum, final asymptote intensity, slope1Param, midpoint1Param, slope2Param, and midpoint distance) describing the double sigmoidal fit as output. It also contains information about the goodness of fits such as AIC, BIC, residual sum of squares, and log likelihood.
}
\examples{
# runif() is used here for consistency with previous versions of the sicegar package. However,
# rnorm() will generate symmetric errors, producing less biased numerical parameter estimates.
# We recommend errors generated with rnorm() for any simulation studies on sicegar.
time=seq(3, 24, 0.1)

#simulate intensity data and add noise
noise_parameter <- 0.2
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- doublesigmoidalFitFormula_h0(time,
                                     finalAsymptoteIntensityRatio = .3,
                                     maximum = 4,
                                     slope1Param = 1,
                                     midPoint1Param = 7,
                                     slope2Param = 1,
                                     midPointDistanceParam = 8,
                                     h0 = 1)
intensity <- intensity + intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- normalizeData(dataInput)
parameterVector <- doublesigmoidalFitFunction_h0(normalizedInput, tryCounter = 1)


#Check the results
# doublesigmoidalFitFunction_h0() is run on the startList param values (because 'tryCounter = 1')
# use multipleFitFunction() for multiple random starts in order to optimize
if(parameterVector$isThisaFit){
    intensityTheoretical <-
         doublesigmoidalFitFormula_h0(
             time,
             finalAsymptoteIntensityRatio = parameterVector$finalAsymptoteIntensityRatio_Estimate,
             maximum = parameterVector$maximum_Estimate,
             slope1Param = parameterVector$slope1Param_Estimate,
             midPoint1Param = parameterVector$midPoint1Param_Estimate,
             slope2Param = parameterVector$slope2Param_Estimate,
             midPointDistanceParam = parameterVector$midPointDistanceParam_Estimate,
             h0 = parameterVector$h0_Estimate)

 comparisonData <- cbind(dataInput, intensityTheoretical)

 require(ggplot2)
 ggplot(comparisonData) +
   geom_point(aes(x = time, y = intensity)) +
   geom_line(aes(x = time, y = intensityTheoretical)) +
   expand_limits(x = 0, y = 0)}

if(!parameterVector$isThisaFit) {print(parameterVector)}

}
