% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_sigs.R
\name{list_sigs}
\alias{list_sigs}
\alias{list_sigs.default}
\alias{list_sigs.sig}
\alias{list_sigs.character}
\title{List the signatures of all functions}
\usage{
list_sigs(x, pattern = NULL, ...)

\method{list_sigs}{default}(x, pattern = NULL, ...)

\method{list_sigs}{sig}(x, pattern = NULL, ...)

\method{list_sigs}{character}(x, pattern = NULL, ...)
}
\arguments{
\item{x}{An environment or the the path to a file.}

\item{pattern}{An optional regular expression. Only names
matching pattern are returned.}

\item{...}{Currently ignored}
}
\value{
An object of class \code{siglist}, which is a list
of \code{sig} objects.
}
\description{
Lists the signatures of all functions in an environment
or file.
}
\examples{
#From a package
list_sigs(pkg2env(graphics))
#Just functions beginning with 'a'.
list_sigs(pkg2env(graphics), pattern = "^a")
#From a file
list_sigs(system.file("extdata", "sample.R", package = "sig"))
}
