% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig.R
\name{sig}
\alias{sig}
\alias{sig.default}
\alias{sig.character}
\alias{sig.call}
\alias{sig.formula}
\alias{sig.name}
\title{Generate a function signature object}
\usage{
sig(fn, name_override, ...)

\method{sig}{default}(fn, ...)

\method{sig}{character}(fn, ...)

\method{sig}{call}(fn, ...)

\method{sig}{formula}(fn, ...)

\method{sig}{name}(fn, ...)
}
\arguments{
\item{fn}{A function.}

\item{name_override}{Override the default function name.
See examples.}

\item{...}{For possible additional future arguments, currently unused.}
}
\value{
A list, with the elements
\itemize{
  \item{name}{The name of the function.}
  \item{args}{The arguments of the function.}
}
}
\description{
Generates a signature object for a function.
}
\note{
Anonymous functions are given the name "..anonymous..". 

Nonstandard names ("foo bar"), assignment fns ("foo<-"),
operators ("%foo%") and reserved names ("repeat") are wrapped
in backquotes.
}
\examples{
sig(R.Version)               #no args
sig(scan)                    #lots of args
sig(function(x, y) {x + y})  #anonymous
sig(sum)                     #primitive

sig("sd")                   #string input
sig("function(x, y) {x + y}")
sig(~ prod)                 #formula input
sig(~ function(x, y) {x + y})
sig(quote(paste0))          #name input
sig(quote(function(x, y) {x + y}))

fn_list <- list(
  mean = mean, 
  var = var
)
lapply(fn_list, sig)         #names are a mess
Map(                         #use Map for lists
  sig, 
  fn_list, 
  names(fn_list)             #Map mangles names, so override
)            
}
