% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_layer.R
\name{clip_multipoligon}
\alias{clip_multipoligon}
\title{Safe Clip a Multipolygon Vector Layer}
\usage{
clip_multipoligon(vector, polygon)
}
\arguments{
\item{vector}{A `sf` multipolygon vector layer to be clipped.}

\item{polygon}{A `sf` polygon layer used as the clipping geometry.}
}
\value{
A `sf` vector layer with the clipped geometries.
}
\description{
Clips a `MULTIPOLYGON` vector layer using a polygon layer, handling specific
issues that might arise with geometries encoded incorrectly or containing unknown WKB types.
It serves as a fallback when the `clip_layer` function fails due to errors like
`ParseException: Unknown WKB type 12`, which is associated with *MULTIPOLYGON* types.
}
\details{
The function ensures that the input layer is correctly encoded as `MULTIPOLYGON` and
uses GDAL utilities for re-encoding if necessary. The output is projected to the CRS
of the clipping polygon.

This solution is inspired by a discussion on handling WKB type errors in R:
<https://gis.stackexchange.com/questions/389814/r-st-centroid-geos-error-unknown-wkb-type-12>.
}
\examples{
gpkg_path <- system.file("extdata", "clc.gpkg", package = "clc")

clc <- sf::st_read(gpkg_path, layer = "clc", quiet = TRUE)
lanjaron <- sf::st_read(gpkg_path, layer = "lanjaron", quiet = TRUE)

clc_clipped <- clip_multipoligon(clc, lanjaron)

}
\seealso{
Other clip functions: 
\code{\link{clip_layer}()},
\code{\link{clip_raster}()},
\code{\link{generate_bbox}()}
}
\concept{clip functions}
