% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_publish_raster.R
\name{publish_raster}
\alias{publish_raster}
\alias{publish_raster.geoserver}
\title{Publish a Raster to GeoServer}
\usage{
publish_raster(gso, raster, layer)

\method{publish_raster}{geoserver}(gso, raster, layer = NULL)
}
\arguments{
\item{gso}{An object of class `geoserver` containing GeoServer connection details.}

\item{raster}{A character string specifying the file path to the GeoTIFF raster file
to be uploaded.}

\item{layer}{A string, the name of the layer to publish. If it is `NULL`, which is
the default value, the layer name is derived from the filename.}
}
\value{
An integer:
\itemize{
  \item \code{0} if the operation was successful or if the layer already exists.
  \item \code{1} if an error occurred.
}
}
\description{
Publishes a GeoTIFF raster file to a workspace and data store on a GeoServer instance.
}
\examples{
\dontrun{
gso <- geoserver(
  url = "http://localhost:8080/geoserver",
  user = "admin",
  password = "geoserver",
  workspace = "sigugr_test"
)

source_tif <- system.file("extdata/sat.tif", package = "sigugr")

gso |>
  publish_raster(source_tif, "sat-tiff")
}
}
\seealso{
Other publish to GeoServer: 
\code{\link{geoserver}()},
\code{\link{publish_bands}()},
\code{\link{publish_layer}()},
\code{\link{publish_layer_set}()},
\code{\link{register_datastore_postgis}()}
}
\concept{publish to GeoServer}
