% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_multinom_probs.R
\name{generate_multinom_probs}
\alias{generate_multinom_probs}
\title{Generate Probabilities for Multinomial Draws}
\usage{
generate_multinom_probs(V = NULL, B = NULL, X = NULL, X.incl.X0 = FALSE)
}
\arguments{
\item{V}{A numeric value stating the number of categories desired.}

\item{B}{A list, each element of which contains a parameter vector. The 
list should have length \code{V - 1}, i.e., should contain parameter values
associated with all categories except the reference category, following 
Agresti (2007). Alternatively, \code{B} may be a list of length \code{V} 
if one desires to specify parameters for every category, i.e., the
over-parameterized model used in Friedman (2010).}

\item{X}{A matrix, each row of which contains subject covariate/predictor 
values.}

\item{X.incl.X0}{Logical. When \code{TRUE}, \code{X} should contain column
of 1's for the intercept. Otherwise, a column of 1's is generated 
internally. Default is \code{FALSE}.}
}
\value{
A matrix containing subject-specific probabilities for each 
category of the multinomial distribution. The number of rows equals 
\code{nrow(X)} and the number of columns equals \code{V}.
}
\description{
Obtain probabilities for each category of a multinomial distribution
based on covariate and parameter values based on the logit models
for the multinomial distribution.
}
\examples{
## number of categories
vt <- 3

## covariate values
xt <- matrix(rnorm(10 * 2), ncol = 2, nrow = 10)

## list of parameter vectors
bt <- list(b1 = c(1, 0.25, -0.25),
           b2 = c(-0.5, 0.15, 0.15))
           
## list of parameter vectors (over-parameterized model)
bu <- list(b1 = c(1, 0.25, -0.25),
           b2 = c(-0.5, 0.15, 0.15),
           b3 = c(-1, 0.1, -0.20))

## subject specific probabilities for each category
generate_multinom_probs(V = vt, X = xt, B = bt)

## subject specific probabilities for each category 
## (over-parameterized model)
generate_multinom_probs(V = vt, X = xt, B = bu)

}
\references{
\insertRef{Agresti:2007}{sim2Dpredictr}

\insertRef{Friedman:2010}{sim2Dpredictr}
}
