% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.boin_summary.R
\name{print.boin_summary}
\alias{print.boin_summary}
\title{Print Method for BOIN Summary Objects}
\usage{
\method{print}{boin_summary}(x, scenario_name = NULL, percent = FALSE, kable = FALSE, kable_format = "pipe", ...)
}
\arguments{
\item{x}{Object of class "boin_summary" returned by \code{sim_boin()}.}

\item{scenario_name}{Character. Optional name for the scenario. If provided, displayed as header.
Default is NULL.}

\item{percent}{Logical. If TRUE, display average patients and DLTs as percentages of totals.
If FALSE (default), display as absolute numbers.}

\item{kable}{Logical. If TRUE, format output as knitr::kable table. If FALSE (default),
display as plain text table.}

\item{kable_format}{Character. Format for kable output when kable = TRUE. Options include
"pipe" (Markdown pipes, default), "simple" (minimal formatting),
"latex" (LaTeX format), and "html" (HTML format). Default is "pipe".}

\item{...}{Additional arguments (currently unused, for S3 method consistency).}
}
\value{
Invisibly returns the input object \code{x}. Function is called for printing side effect.
}
\description{
Custom print method for "boin_summary" S3 class objects returned by
\code{sim_boin()}. Displays operating characteristics in a formatted table.
}
\details{
Displays operating characteristics in a unified table with rows:
\enumerate{
\item True Tox (\%): True DLT rate at each dose
\item MTD Sel (\%): Percentage selecting each dose as MTD (+ No MTD)
\item Avg Pts: Average enrollment per dose (absolute or percentage)
\item Avg DLTs: Average DLT count per dose (absolute or percentage)
}

When \code{percent = TRUE}, Avg Pts and Avg DLTs are displayed as
percentages of their respective totals for each trial.

When \code{kable = TRUE}, output is formatted using \code{knitr::kable()}.
This is useful for R Markdown documents and reports. The \code{kable_format}
parameter controls the output format: "pipe" for Markdown pipes (default),
"simple" for minimal formatting, "latex" for LaTeX tables, and "html" for
HTML tables with enhanced styling.

When \code{kable_format = "html"}, additional styling is applied including
striped rows, hover effects, and responsive formatting via kableExtra.
}
\examples{
\donttest{
# Create BOIN simulation results
result <- sim_boin(
  n_trials = 1000,
  target = 0.30,
  p_true = c(0.10, 0.25, 0.40),
  n_cohort = 10,
  cohort_size = 3,
  seed = 123
)

# Print with absolute numbers (default)
print(result$summary, scenario_name = "Absolute Numbers")

# Print with percentages
print(result$summary, scenario_name = "Percentages", percent = TRUE)

# Print as Markdown table
print(result$summary, kable = TRUE, kable_format = "pipe")

# Print as HTML table with enhanced styling
print(result$summary, kable = TRUE, kable_format = "html")
}

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
