% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.R
\name{eff}
\alias{eff}
\alias{deff}
\alias{peff}
\alias{qeff}
\alias{reff}
\title{Effectiveness Distributions}
\usage{
deff(x, .eff)

peff(q, .eff)

qeff(p, .eff)

reff(n, .eff)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{.eff}{the \code{eff} object representing the effectiveness distribution.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{deff} gives the density, \code{peff} gives the distribution function, \code{qeff}
  gives the quantile function, and \code{reff} generates random variates.
}
\description{
Density, distribution function, quantile function and random generation for an effectiveness
distribution.
}
\examples{
# sample distribution from AP scores
e <- effCont_beta(web2010ap[,1])
# pdf integrates to 1
integrate(deff, lower = 0, upper = 1, .eff = e)
# qeff (quantile) is the inverse of peff (cumulative)
qeff(peff(.2, e), e)
# random generation of 100 scores
r <- reff(100, e)
}
\seealso{
\code{\link{effCont}} for continuous distributions, and \code{\link{effDisc}} for
  discrete distributions.
}
