% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_distributions.R
\name{rnet.SmWorld}
\alias{rnet.SmWorld}
\title{Call \code{igraph::sample_smallworld} to Generate Random Graph Object from the Watts-Strogatz Small-World Model}
\usage{
rnet.SmWorld(n, dim, nei, p)
}
\arguments{
\item{n}{Size of the network graph (the number of nodes).}

\item{dim}{Same as in \code{igraph::sample_smallworld}: Integer constant, the dimension of the starting lattice.}

\item{nei}{Same as in \code{igraph::sample_smallworld}: Integer constant, the neighborhood within which the vertices of the lattice will be connected.}

\item{p}{Same as in \code{igraph::sample_smallworld}: Real constant between zero and one, the rewiring probability.}
}
\value{
A matrix with n rows, each row lists the indices of friends connected to that particular observation.
}
\description{
Call \code{igraph::sample_smallworld} and convert the output to \code{simcausal} network matrix.
The parameters are the same as those of \code{igraph::sample_smallworld}.
The loop edges aren't allowed (\code{loops = FALSE}) and the multiple edges aren't allowed either \code{multiple = FALSE}.
}
\seealso{
\code{\link{rnet.gnp}}, \code{\link{rnet.gnm}}
}
