% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intEffectAlphaDisease.R
\name{intEffectAlphaDisease}
\alias{intEffectAlphaDisease}
\title{Estimate Effect of Intervention: Modifying Eta Parameter of Disease Process}
\usage{
intEffectAlphaDisease(
  N = 10000,
  alpha = 0.5,
  tau = 5,
  years_lost = FALSE,
  a0 = 1,
  plot = FALSE,
  eta = rep(0.1, 3),
  nu = rep(1.1, 3),
  beta_L0_D = 0.5,
  beta_L0_L = 2,
  beta_L_D = 1,
  beta_A0_D = -0.1,
  beta_A0_L = -1,
  lower = 10^(-30),
  upper = 200
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate. Default is 10,000.}

\item{alpha}{Numeric scalar. Multiplicative factor applied to the disease process shape parameter \eqn{\eta}.}

\item{tau}{Numeric scalar. Time horizon at which proportions are computed.}

\item{years_lost}{Logical. If \code{TRUE}, computes years lost instead of proportions.}

\item{a0}{Binary (0/1). Specifies the group for comparison.}

\item{plot}{Logical. If \code{TRUE}, plots timelines for sample of intervention and non intervention data.}

\item{eta}{Numeric vector of length 3. Shape parameters for Weibull hazards (default \code{rep(0.1, 3)}).}

\item{nu}{Numeric vector of length 3. Scale parameters for Weibull hazards (default \code{rep(1.1, 3)}).}

\item{beta_L0_D}{Numeric scalar. Effect of baseline covariate on death risk (default 0.5).}

\item{beta_L0_L}{Numeric scalar. Effect of baseline covariate on covariate risk (default 2).}

\item{beta_L_D}{Numeric scalar. Effect of covariate process on death risk (default 1).}

\item{beta_A0_D}{Numeric scalar. Effect of baseline treatment on death risk (default -0.1).}

\item{beta_A0_L}{Numeric scalar. Effect of baseline treatment on covariate risk (default -1).}

\item{lower}{Numeric scalar. Lower bound for root-finding in hazard inversion (default 1e-30).}

\item{upper}{Numeric scalar. Upper bound for root-finding in hazard inversion (default 200).}
}
\value{
A list with two components:
\describe{
\item{\code{effect_L}}{Proportion (or years lost) of individuals diagnosed with disease by time \eqn{\tau} in group \code{A0 = a0}, under intervention (\code{G1}) and without intervention (\code{G2}).}
\item{\code{effect_death}}{Proportion (or years lost) of individuals who died by time \eqn{\tau} in group \code{A0 = a0}, under intervention (\code{G1}) and without intervention (\code{G2}).}
}
}
\description{
This function simulates data from the disease setting in two scenarios. Under
intervention on the shape parameter \eqn{\eta} of the disease process is multiplied by
\code{alpha}, and a baseline (non-intervened) scenario. It computes the proportion
of individuals who experience death or disease by a specified time \eqn{\tau}
in the group \code{A0 = a0}, optionally returning years_lost.
The function can also plot a sample of the event data for each scenario for comparison.
}
\examples{
intEffectAlphaDisease(N = 1000, alpha = 0.7, tau = 5, years_lost = FALSE, a0 = 1)
}
