% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.prop2.test}
\alias{sim.prop2.test}
\title{sim.prop2.test}
\usage{
sim.prop2.test(
  simdat.prop2,
  p = NULL,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  correct = TRUE,
  experiment.name = "experiment",
  group.name = "group",
  x.value = "x",
  y.value = "y",
  value.name = "value"
)
}
\arguments{
\item{simdat.prop2}{Data for use in two-sample proportions tests across one or more experiments.  Structure is in the form returned by the function simitation::sim.prop2().}

\item{p}{See help(prop.test).}

\item{alternative}{See help(prop.test).}

\item{conf.level}{See help(prop.test).}

\item{correct}{See help(prop.test).}

\item{experiment.name}{A character value providing the name of the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{x.value}{A character value providing a label for the first group in the two-sample t test in the column of data named by group.name.}

\item{y.value}{A character value providing a label for the second group in the two-sample t test in the column of data named by group.name.}

\item{value.name}{A character value providing the name of the column identifying the values.}
}
\value{
A data.table containing test statistics for each experiment based on the two-sample proportions test.
}
\description{
sim.prop2.test
}
\examples{

simdat.prop2 <- sim.prop2(nx = 30, ny = 40, px = 0.5, py = 0.55,
num.experiments = 2, experiment.name = "sim", group.name = "treatment",
 x.value = "group_1", y.value = "group_2", value.name = "correct_answer",
  seed = 3)

test.statistics.prop2 <- sim.prop2.test(simdat.prop2 = simdat.prop2,
 p = NULL, alternative = "less", conf.level = 0.95, correct = TRUE,
 experiment.name = "sim", group.name = "treatment", x.value = "group_1",
  y.value = "group_2", value.name = "correct_answer")

}
