% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simulation.steps}
\alias{simulation.steps}
\title{simulation.steps}
\usage{
simulation.steps(
  the.steps,
  n,
  num.experiments = 1,
  experiment.name = "experiment",
  step.split = "~",
  seed = 62,
  vstr = 3.6
)
}
\arguments{
\item{the.steps}{A character vector of variables to simulate.  The variables are simulated in the order specified.  Later variables can be generated to depend on earlier variables.  The possible specifications include:}

\item{n}{A numeric value for the number of observations in each experiment.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{step.split}{A character value that separates the name of the variable to be simulated (left side) from its distribution (right side).  Using the.steps = "X ~ N(0,1)" with step.split = "~" will generate a variable named X from a standard Normal distribution.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A data table containing the simulated data based on the sequence of steps specified in the.steps. The data table also includes an additional column identifying the experiment as specified by the experiment.name parameter.
}
\description{
simulation.steps
}
\examples{

step.age <- "Age ~ N(45, 10)"
step.female <- "Female ~ binary(0.53)"
step.health.percentile <- "Health.Percentile ~ U(0,100)"
step.exercise.sessions <- "Exercise.Sessions ~ Poisson(2)"
step.diet <- "Diet ~ sample(('Light', 'Moderate', 'Heavy'),
(0.2, 0.45, 0.35))"

step.healthy.lifestyle <- "Healthy.Lifestyle ~
logistic(log(0.45) - 0.1 * (Age -45) + 0.05 * Female + 0.01 *
Health.Percentile + 0.5 * Exercise.Sessions - 0.1 *
(Diet == 'Moderate') - 0.4 * (Diet == 'Heavy'))"

step.weight <- "Weight ~ lm(150 - 15 * Female + 0.5 *
Age - 0.1 * Health.Percentile - 0.2 * Exercise.Sessions  +
5 * (Diet == 'Moderate') + 15 * (Diet == 'Heavy') -
2 * Healthy.Lifestyle + N(0, 10))"

the.steps <- c(step.age, step.female, step.health.percentile,
 step.exercise.sessions, step.diet, step.healthy.lifestyle, step.weight)

simdat.multivariate <- simulation.steps(the.steps = the.steps,
n = 50, num.experiments = 2, experiment.name = "sim", seed = 41)
}
