% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_sinar.R
\name{emp_cov}
\alias{emp_cov}
\title{Empirical estimate for the Covariance matrix in the Klimko-Nelson.}
\usage{
emp_cov(X)
}
\arguments{
\item{X}{A integer matrix where each cell is the observed value in the
regular lattice.}
}
\value{
The covariance matrix estimated empirically.
}
\description{
\eqn{\Sigma} is the covariance matrix in the Klimko-Nelson seminal paper.
Basically, we know
\deqn{\sqrt{n}(\hat{a}_{10} - a_{10}, \hat{a}_{01} - a_{01}, \hat{a}_{11} -
 a_{11}, \hat{\mu}_\epsilon - \mu_\epsilon)^\top \sim MNV(0, \Sigma)}
where
\deqn{\Sigma = V^{-1}W V^{-1}.}
For more details, check Klimko and Nelson (1978).
}
\examples{

data("nematodes")
emp_cov(nematodes)
}
