% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepDF.R
\name{prepDF}
\alias{prepDF}
\title{Prepare nested dataset}
\usage{
prepDF(df, unitID, subunitID)
}
\arguments{
\item{df}{dataframe}

\item{unitID}{character; unit column name in original dataset}

\item{subunitID}{character; sub-unit column name in original dataset}
}
\value{
processed dataframe
}
\description{
Prepare nested dataset
}
\examples{
################################################################################
############## Prepare dataframe [sitepickR Package] ###########################
######### Robert Olsen, Elizabeth A. Stuart & Elena Badillo-Goicoechea (2022) ##

# Basic usage of prepDF()

rawCCD <- sitepickR::rawCCD

uSampVarsCCD <- c("w.pct.frlunch", "w.pct.black", "w.pct.hisp", "w.pct.female") 
suSampVarsCCD <- c("sch.pct.frlunch", "sch.pct.black", "sch.pct.hisp", "sch.pct.female")

dfCCD <- prepDF(rawCCD,
                unitID="LEAID", subunitID="NCESSCH")
}
