% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_exists}
\alias{aws_bucket_exists}
\title{Check if an S3 bucket exists}
\usage{
aws_bucket_exists(bucket)
}
\arguments{
\item{bucket}{(character) bucket name; must be length 1. required}
}
\value{
a single boolean (logical)
}
\description{
Check if an S3 bucket exists
}
\note{
internally uses
\href{https://www.paws-r-sdk.com/docs/s3_head_bucket/}{head_bucket}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket1 <- random_bucket()
aws_bucket_create(bucket1)

# exists
aws_bucket_exists(bucket = bucket1)
# does not exist
aws_bucket_exists(bucket = "no-bucket")

# cleanup
six_bucket_delete(bucket1, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
