% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{six_bucket_permissions}
\alias{six_bucket_permissions}
\title{Get permissions for a bucket}
\usage{
six_bucket_permissions(bucket)
}
\arguments{
\item{bucket}{(character) bucket name. required}
}
\value{
tibble with a row for each user, with columns:
\itemize{
\item user (always present)
\item permissions (always present)
\item policy_read (optionally present) the policy name behind the "read"
permission (if present)
\item policy_admin (optionally present) the policy name behind the "admin"
permission (if present)
}

Note that users with no persmissions are not shown; see \code{\link[=aws_users]{aws_users()}}
}
\description{
Get permissions for a bucket
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a bucket
bucket <- random_bucket()
if (!aws_bucket_exists(bucket)) aws_bucket_create(bucket)

# create user
user <- random_user()
if (!aws_user_exists(user)) aws_user_create(user)

six_bucket_permissions(bucket)
six_bucket_add_user(bucket, user, permissions = "read")
six_bucket_permissions(bucket)
six_bucket_remove_user(bucket, user)
six_bucket_permissions(bucket)

# cleanup
six_user_delete(user)
aws_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
