% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{six_file_upload}
\alias{six_file_upload}
\title{Magically upload a file}
\usage{
six_file_upload(path, bucket, force = FALSE, ...)
}
\arguments{
\item{path}{(character) one or more file paths to add to
the \code{bucket}. required. cannot include directories}

\item{bucket}{(character) bucket to copy files to. required.
if the bucket does not exist we prompt you asking if you'd like
the bucket to be created}

\item{force}{(logical) force bucket creation without going through
the prompt. default: \code{FALSE}. Should only be set to \code{TRUE} when
required for non-interactive use.}

\item{...}{named params passed on to
\href{https://www.paws-r-sdk.com/docs/s3_put_object/}{put_object}}
}
\value{
(character) a vector of remote s3 paths where your
files are located
}
\description{
Magically upload a file
}
\section{What is magical}{

\itemize{
\item Exits early if files do not exist
\item Exits early if any \code{path} values are directories
\item Creates the bucket if it does not exist
\item Adds files to the bucket, figuring out the key to use from
the supplied path
\item Function is vectoried for the \code{path} argument; you can
pass in many file paths
}
}

\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket1 <- random_bucket()
demo_rds_file <- file.path(system.file(), "Meta/demo.rds")
six_file_upload(demo_rds_file, bucket1, force = TRUE)

# path doesn't exist, error
try(
  six_file_upload("file_doesnt_exist.txt", random_bucket())
)

# directories not supported, error
mydir <- tempdir()
try(
  six_file_upload(mydir, random_bucket())
)

# Cleanup
six_bucket_delete(bucket1, force = TRUE)
\dontshow{\}) # examplesIf}
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# requires user interaction with prompts ...
bucket2 <- random_bucket()
demo_rds_file <- file.path(system.file(), "Meta/demo.rds")
six_file_upload(demo_rds_file, bucket2)

## many files at once
links_file <- file.path(system.file(), "Meta/links.rds")
six_file_upload(c(demo_rds_file, links_file), bucket2)

# set expiration, expire 1 minute from now
six_file_upload(demo_rds_file, bucket2, Expires = Sys.time() + 60)

# bucket doesn't exist, ask if you want to create it
not_a_bucket <- random_string("not-a-bucket-")
six_file_upload(demo_rds_file, not_a_bucket)

# Cleanup
six_bucket_delete(bucket2, force = TRUE)
six_bucket_delete(not_a_bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_copy}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()}

Other magicians: 
\code{\link{six_admin_setup}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()},
\code{\link{six_user_create}()},
\code{\link{six_user_delete}()}
}
\concept{files}
\concept{magicians}
