% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{six_user_delete}
\alias{six_user_delete}
\title{Delete a user}
\usage{
six_user_delete(username)
}
\arguments{
\item{username}{(character) A user name. required}
}
\value{
an empty list
}
\description{
Delete a user
}
\details{
See \url{https://www.paws-r-sdk.com/docs/iam_delete_user/}
docs for more details
}
\section{What is magical}{

\itemize{
\item Detaches any attached policies
\item Deletes any access keys
\item Then deletes the user
}
}

\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
name <- random_user()
six_user_create(name)
six_user_delete(name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other users: 
\code{\link{aws_user}()},
\code{\link{aws_user_access_key}()},
\code{\link{aws_user_access_key_delete}()},
\code{\link{aws_user_add_to_group}()},
\code{\link{aws_user_create}()},
\code{\link{aws_user_current}()},
\code{\link{aws_user_delete}()},
\code{\link{aws_user_exists}()},
\code{\link{aws_users}()},
\code{\link{six_user_create}()}

Other magicians: 
\code{\link{six_admin_setup}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()},
\code{\link{six_file_upload}()},
\code{\link{six_user_create}()}
}
\concept{magicians}
\concept{users}
