% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_SDM}
\alias{simulate_SDM}
\title{Simulate joint Species Distribution Models}
\usage{
simulate_SDM(
  env = 5L,
  sites = 100L,
  species = 5L,
  correlation = TRUE,
  weight_range = c(-1, 1),
  link = "probit",
  response = "pa",
  sparse = NULL,
  tolerance = 0.05,
  iter = 20L,
  seed = NULL
)
}
\arguments{
\item{env}{number of environment variables}

\item{sites}{number of sites}

\item{species}{number of species}

\item{correlation}{correlated species TRUE or FALSE, can be also a function or a matrix}

\item{weight_range}{sample true weights from uniform range, default -1,1}

\item{link}{probit, logit or identical}

\item{response}{pa (presence-absence) or count}

\item{sparse}{sparse rate}

\item{tolerance}{tolerance for sparsity check}

\item{iter}{tries until sparse rate is achieved}

\item{seed}{random seed. Default = 42}
}
\value{
List of simulation results:

\item{env}{Number of environmental covariates}
\item{species}{Number of species}
\item{sites}{Number of sites}
\item{link}{Which link}
\item{response_type}{Which response type}
\item{response}{Species occurrence matrix}
\item{correlation}{Species covariance matrix}
\item{species_weights}{Species-environment coefficients}
\item{env_weights}{Environmental covariates}
\item{corr_acc}{Method to calculate sign accurracy}
}
\description{
Simulate species distributions
}
\details{
Probit is not possible for abundance response (response = 'count')
}
\author{
Maximilian Pichler
}
