% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slanter.R
\name{slanted_reorder}
\alias{slanted_reorder}
\title{Reorder data rows and columns to move high values close to the diagonal.}
\usage{
slanted_reorder(
  data,
  order_data = NULL,
  order_rows = TRUE,
  order_cols = TRUE,
  squared_order = TRUE,
  same_order = FALSE,
  discount_outliers = TRUE
)
}
\arguments{
\item{data}{A rectangular matrix to reorder, of non-negative values (unless \code{order_data} is specified).}

\item{order_data}{An optional matrix of non-negative values of the same size to use for computing the orders.}

\item{order_rows}{Whether to reorder the rows.}

\item{order_cols}{Whether to reorder the columns.}

\item{squared_order}{Whether to reorder to minimize the l2 norm (otherwise minimizes the l1 norm).}

\item{same_order}{Whether to apply the same order to both rows and columns.}

\item{discount_outliers}{Whether to do a final order phase discounting outlier values far from the diagonal.}
}
\value{
A matrix of the same shape whose rows and columns are a permutation of the input.
}
\description{
Given a matrix expressing the cross-similarity between two (possibly different) sets of entities,
this uses \code{slanted_orders} to compute the "best" order for visualizing the matrix, then
returns the reordered data. Commonly used in \code{pheatmap(slanted_reorder(data), ...)}, and of
course \code{sheatmap} does this internally for you.
}
\examples{
slanter::slanted_reorder(cor(t(mtcars)))
}
