% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{beetles}
\alias{beetles}
\title{Beetle mating}
\format{
A data frame with 5 variables: \code{DFemale}, \code{Treatment}, \code{Species}, \code{MateType}, \code{Eggs}.
\describe{
  \item{DFemale}{Factor. Unique identifier for each female subject in the experiment.}
  \item{Treatment}{Factor. Experimental treatment group assigned to each female.}
  \item{Species}{Factor. Species designation for each female in the study.}
  \item{MateType}{Factor. Type of mate provided for each female ("Inter" for interspecific or "Intra" for intraspecific, as relevant).}
  \item{Eggs}{Integer. Number of eggs laid by each female during the observation period.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}

Peacock, L., Batley, J., Dungait, J. A. J., Barker, J. H. A., Powers, S. J. & Karp, A. (2004). \emph{A comparative study of interspecies mating of Phratora vulgatissima and P. vitellinae using behavioural tests and molecular markers}. Entomologia Experimentalis et Applicata, 110(3), 231–241.
}
\usage{
beetles
}
\description{
The dataset comes from a completely randomized experiment investigating the viability of interspecies and intraspecies mating in two willow beetle species (Phratora vitellinae and Phratora vulgatissima). Females from each species were mated with males of either the same or the other species, giving four treatments with 10 replicates per treatment. The dataset includes the factor Treatment, identifying the mating combination, and the response variable Eggs, which records the number of eggs laid by each female, and is used to compare reproductive outcomes across mating types.
}
\examples{
fit <- lm(log10(Eggs) ~ Species * MateType, data = beetles)
anova(fit)

}
\keyword{datasets}
