% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{calibrate}
\alias{calibrate}
\title{ELISA calibration}
\format{
A data frame with 4 variables: \code{Unit}, \code{Prep}, \code{Conc}, \code{Absorbance}.
\describe{
  \item{Unit}{Factor. Unique identifier for each observation or experimental unit.}
  \item{Prep}{Factor. Preparation method applied to the sample.}
  \item{Conc}{Factor. Initial concentration applied to the sample.}
  \item{Absorbance}{Numeric. Measured absorbance value for each sample unit (may contain missing values for invalid readings).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
calibrate
}
\description{
A calibration experiment was conducted to develop an appropriate protocol for an experimental procedure. The study tested three preparation methods (Prep) and four initial concentrations (Conc), combined in a completely randomized design with two replicates per combination. Absorbance values were measured for each solution after application to an ELISA plate and are recorded in the dataset. The data comprise the measured absorbances (Absorbance), the preparation method, and the initial concentration for each unit. One observation (unit 9) was excluded from analysis due to suspected contamination and was marked as missing.
}
\examples{
fit <- lm(log(Absorbance) ~ Prep * Conc,
          data = calibrate |>
             subset(!is.na(Absorbance)))
anova(fit)

}
\keyword{datasets}
