% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.hmrfem.multi.it}
\alias{smfishHmrf.hmrfem.multi.it}
\title{Perform HMRF for multivariate normal distribution. Accepts R data structures as inputs. Accepts multiple betas.}
\usage{
smfishHmrf.hmrfem.multi.it(
  name,
  outdir,
  k,
  y,
  nei,
  beta = 0,
  beta_increment = 1,
  beta_num_iter = 10,
  numnei,
  blocks,
  mu,
  sigma,
  damp
)
}
\arguments{
\item{name}{name for this run (eg test)}

\item{outdir}{output directory}

\item{k}{number of clusters}

\item{y}{gene expression matrix}

\item{nei}{adjacency matrix between cells}

\item{beta}{initial beta}

\item{beta_increment}{beta increment}

\item{beta_num_iter}{number of betas to try}

\item{numnei}{a vector containing number of neighbors per cell}

\item{blocks}{a list of cell colors for deciding the order of cell update}

\item{mu}{a 2D matrix (i,j) of cluster mean (initialization)}

\item{sigma}{a 3D matrix (i,j,k) where (i,j) is the covariance of cluster k (initialization)}

\item{damp}{a list of dampening factors (length = k)}
}
\description{
This function performs HMRF model \insertCite{Zhu2018}{smfishHmrf} on inputs which are directly R data structures. Different from smfishHmrf.hmrfem.multi, this function iterates over multiple betas rather than a single beta. Different from smfishHmrf.hmrfem.multi.it.min, this function accepts R data structures (i.e. parameters y, nei, blocks) as inputs to the function rather than accepting file names. This function will save the results of HMRF to the output directory. It will return void.

This function exists for legacy and compatibility reason. User should use \strong{smfishHmrf.hmrfem.multi.it.min} function.
}
\section{More information}{

Arguments mu and sigma refer to the cluster centroids from running kmeans algorithm.
They serve as initialization of HMRF.
Users should refer to \strong{smfishHmrf.hmrfem.multi.it.min} for more information about function parameters and the requirements.
}

\examples{
y<-as.matrix(read.table(system.file("extdata", "ftest.expression.txt", 
    package="smfishHmrf"), header=FALSE, row.names=1))
nei<-as.matrix(read.table(system.file("extdata", "ftest.adjacency.txt", 
    package="smfishHmrf"), header=FALSE, row.names=1))
colnames(nei)<-NULL; rownames(nei)<-NULL
blocks<-c(t(read.table(system.file("extdata", "ftest.blocks.txt", 
    package="smfishHmrf"), header=FALSE, row.names=1)))
blocks<-lapply(1:max(blocks), function(x) which(blocks == x))
numnei<-apply(nei, 1, function(x) sum(x!=-1))
k<-9
kmeans_results = system.file("extdata", package="smfishHmrf")
kk = smfishHmrf.generate.centroid.use.exist(name="test", input_dir=kmeans_results, k)
numcell<-dim(y)[1]; m<-dim(y)[2]
mu<-t(kk$centers) #should be dimension (m,k)
lclust<-lapply(1:k, function(x) which(kk$cluster == x))
damp<-array(0, c(k)); sigma<-array(0, c(m,m,k))
for(i in 1:k){
    sigma[, , i] <- cov(y[lclust[[i]], ])
    di<-findDampFactor(sigma[,,i], factor=1.05, d_cutoff=1e-5, startValue=0.0001)
    damp[i]<-ifelse(is.null(di), 0, di)
} 
smfishHmrf.hmrfem.multi.it(name="test", outdir=tempdir(), k=k, y=y, nei=nei, 
    beta=28, beta_increment=2, beta_num_iter=1, numnei=numnei, blocks=blocks, 
    mu=mu, sigma=sigma, damp=damp)

\dontrun{
# alternatively, to test a larger set of betas:
smfishHmrf.hmrfem.multi.it(name="test", outdir=tempdir(), k=k, y=y, nei=nei, 
    beta=0, beta_increment=2, beta_num_iter=20, numnei=numnei, blocks=blocks, 
    mu=mu, sigma=sigma, damp=damp)
}


}
\references{
\insertRef{Zhu2018}{smfishHmrf}
}
