% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.hmrfem.multi.save}
\alias{smfishHmrf.hmrfem.multi.save}
\title{Save the HMRF result}
\usage{
smfishHmrf.hmrfem.multi.save(name, outdir, beta, tc.hmrfem, k)
}
\arguments{
\item{name}{name for this run (eg test)}

\item{outdir}{output directory}

\item{beta}{beta to save}

\item{tc.hmrfem}{the result of running of hmrfem on single beta (from smfishHmrf.hmrfem.multi)}

\item{k}{number of clusters}
}
\description{
This function assumes that HMRF has been run via smfishHmrf.hmrfem.multi, smfishHmrf.hmrfem.multi.it or smfishHmrf.hmrfem.multi.it.min function. It assumes the results have been generated. This function saves the results of each beta to the output directory. It will return void.
}
\examples{
data(seqfishplus)
s <- seqfishplus
tc.hmrfem<-smfishHmrf.hmrfem.multi(s$y, s$nei, s$numnei, s$blocks, beta=28,
    mu=s$mu, sigma=s$sigma, err=1e-7, maxit=50, verbose=TRUE, dampFactor=s$damp,
    tolerance=1e-5)
smfishHmrf.hmrfem.multi.save(name="test", outdir=tempdir(), beta=28, tc.hmrfem=tc.hmrfem, k=9)
}
