% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sev_pexp}
\alias{sev_pexp}
\title{Calculate Smallest Eigenvalue for Power Exponential Correlation Matrices}
\usage{
sev_pexp(range_nu, range_rho, grid_len = 50, dmat)
}
\arguments{
\item{range_nu}{A numeric vector of length 2, specifying the minimum and
maximum values for the power parameter \code{nu}. \code{nu} typically ranges between
0 and 2 (e.g., \code{nu = 1} for exponential, \code{nu = 2} for Gaussian).}

\item{range_rho}{A numeric vector of length 2, specifying the minimum and
maximum values for the practical range parameter \code{rho}. \code{rho} must be
positive.}

\item{grid_len}{An integer specifying the number of points to create for
both \code{nu} and \code{rho} sequences. The total number of grid combinations will
be \code{grid_len^2}. Default is 50.}

\item{dmat}{A numeric matrix representing the distance matrix between
locations.  The distances should be non-negative.}
}
\value{
A \link[dplyr:reexports]{tibble} with three columns:
\item{rho}{The practical range parameter value.}
\item{nu}{The power parameter value.}
\item{lambda}{The smallest eigenvalue of the power exponential correlation
matrix corresponding to the \code{rho} and \code{nu} pair.}
}
\description{
This function computes the smallest eigenvalue of a correlation
matrix derived from the power exponential correlation function. It
evaluates this across a grid of values for the power parameter (\code{nu}) and
the practical range parameter (\code{rho}), based on a provided distance
matrix.
}
\details{
The practical range \code{rho} is defined here as the distance at which
the correlation is 0.1. The internal scale parameter \code{phi} is calculated
as \code{phi = rho / (log(10)^(1/nu))}. The power exponential correlation
function is assumed to be of the form C(h) = exp(-(h/phi)^nu), where h is
distance.  The function \code{smile:::pexp_cov} is used internally to compute
the covariance/correlation matrix with a sill of 1.

The function first creates a grid of \code{nu} and \code{rho} parameters. For
each pair of (\code{rho}, \code{nu}) in the grid: 1. It calculates the scale
parameter \code{phi} for the power exponential correlation function, where \code{phi = rho / (log(10)^(1/nu))}. This definition implies that the correlation is
0.1 at the distance \code{rho}.  2. It computes the power exponential
correlation matrix using \code{smile:::pexp_cov(dists = dmat, sill = 1, range = phi, smooth = nu)}.  Note the use of an internal function from the \code{smile}
package.  3. It calculates the eigenvalues of this correlation matrix.
4. The minimum eigenvalue is extracted.  The final output is a tibble
containing all parameter combinations and their corresponding minimum
eigenvalues.
}
