% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_common_axis.R
\name{sm_common_axis}
\alias{sm_common_axis}
\title{A function to plot panels with common x- and y- axes}
\usage{
sm_common_axis(location, hmargin = 1, wmargin = 1)
}
\arguments{
\item{location}{Location of the panel.
`'topleft'`: removes x-axis title, x-axis ticklabel, y-axis title.
`'topright'`:  removes x-axis title, x-axis ticklabel, y-axis title, y-axis ticklabel.
`'bottomleft'`: removes x-axis title, y-axis title.
`'bottomright'`: removes x-axis title, y-axis title, y-axis ticklabel.
`'topcenter'`: removes x-axis title, x-axis ticklabel, y-axis title, y-axis ticklabel.
`'bottomcenter'`: removes x-axis title, y-axis title, y-axis ticklabel.
`'single'`: keeps all ticks but removes title
`'centerleft'` : removes some ticks and titles
`'centerright'` : removes some ticks and titles
`'center'`: removes everything}

\item{hmargin}{The amount of height of blank space between subplots. It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 1, which should reduce the empty space (right and left side of each panel)
between the panels.}

\item{wmargin}{The amount of width of blank space between subplots. It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 1, which should reduce the empty space (right and left side of each panel)
between the panels.}
}
\value{
Returns a ggplot2 output with ticks removed.
}
\description{
This function is used to create a composite figure.
}
\examples{
library(ggplot2)
library(smplot2)
set.seed(1) # generate random data
day1 = rnorm(16,2,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c('Day 1', 'Day 2'), each = length(day1))
df <- cbind(Subject, Data, Day)

# with aesthetic defaults of smplot
ggplot(data = df, mapping = aes(x = Day, y = Value, color = Day)) +
sm_bar() +
scale_color_manual(values = sm_color('blue','orange')) +
sm_common_axis('bottomleft')


}
