% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JSRM_binary.R
\name{LPJSM_binary}
\alias{LPJSM_binary}
\alias{summary.LPJSM_binary}
\alias{print.summary.LPJSM_binary}
\alias{print.LPJSM_binary}
\title{LPJSM for snSMART with binary outcomes (3 active treatments or placebo and two
dose level)}
\usage{
LPJSM_binary(data, six = TRUE, DTR = TRUE, ...)

\method{summary}{LPJSM_binary}(object, ...)

\method{print}{summary.LPJSM_binary}(x, ...)

\method{print}{LPJSM_binary}(x, ...)
}
\arguments{
\item{data}{dataset with columns named as \code{treatment_stageI}, \code{response_stageI},
\code{treatment_stageII} and \code{response_stageII}}

\item{six}{if TRUE, will run the six beta model, if FALSE will run the two
beta model. Default is \code{six = TRUE}}

\item{DTR}{if TRUE, will also return the expected response rate and its standard
error of dynamic treatment regimens}

\item{...}{optional arguments that are passed to \code{geepack::geeglm()} function.}

\item{object}{object to print}

\item{x}{object to summarize.}
}
\value{
a \code{list} containing
\item{\code{GEE_output}}{ - original output of the GEE (geeglm) model}
\item{\code{pi_hat}}{ - estimate of response rate/treatment effect}
\item{\code{sd_pi_hat}}{ - standard error of the response rate}
\item{\code{pi_DTR_hat}}{ - expected response rate of dynamic treatment regimens (DTRs)}
\item{\code{pi_DTR_se}}{ - standard deviation of DTR estimates}
}
\description{
A joint-stage regression model (LPJSM) is a frequentist modeling approach that
incorporates the responses of both stages as repeated measurements for each subject.
Generalized estimating equations (GEE) are used to estimate the response rates of
each treatment. The marginal response rates for each DTR can also be obtained based
on the GEE results.
}
\examples{
data <- data_binary

LPJSM_result <- LPJSM_binary(data = data, six = TRUE, DTR = TRUE)

summary(LPJSM_result)

}
\references{
Wei, B., Braun, T.M., Tamura, R.N. and Kidwell, K.M., 2018. A Bayesian analysis of small n sequential multiple assignment randomized trials (snSMARTs).
Statistics in medicine, 37(26), pp.3723-3732. URL: \url{doi:10.1002/sim.7900}

Chao, Y.C., Trachtman, H., Gipson, D.S., Spino, C., Braun, T.M. and Kidwell, K.M., 2020. Dynamic treatment regimens in small n, sequential, multiple assignment, randomized trials: An application in focal segmental glomerulosclerosis. Contemporary clinical trials, 92, p.105989. URL: \url{doi:10.1016/j.cct.2020.105989}

Fang, F., Hochstedler, K.A., Tamura, R.N., Braun, T.M. and Kidwell, K.M., 2021. Bayesian methods to compare dose levels with placebo in a small n,
sequential, multiple assignment, randomized trial. Statistics in Medicine, 40(4), pp.963-977. URL: \url{doi:10.1002/sim.8813}
}
\seealso{
\code{\link{BJSM_binary}} \cr
\code{\link{sample_size}}
}
