% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.validation.R
\name{kfold_cross_validation}
\alias{kfold_cross_validation}
\title{Perform K-Fold Cross Validation}
\usage{
kfold_cross_validation(
  data,
  formula,
  model_function,
  predict_function = predict,
  metric_function = NULL,
  k = 5,
  seed = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing the dataset}

\item{formula}{A formula specifying the model (e.g., y ~ x1 + x2)}

\item{model_function}{Function to fit the model (e.g., lm, glm)}

\item{predict_function}{Function to make predictions (default: predict)}

\item{metric_function}{Function to calculate performance metric}

\item{k}{Number of folds (default: 5)}

\item{seed}{Random seed for reproducibility (optional)}

\item{...}{Additional arguments passed to model_function}
}
\value{
A list containing fold results and summary statistics
}
\description{
Perform K-Fold Cross Validation
}
