% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical.efficiency.change.R
\name{technical.efficiency.change}
\alias{technical.efficiency.change}
\title{Technical and efficiency change estimation}
\usage{
technical.efficiency.change(df, input.var.names, output.var.name,
  firm.var.name, time.var.name, method = "u")
}
\arguments{
\item{df}{Data frame with variables used in estimation}

\item{input.var.names}{Names of input variables; must appear in df}

\item{output.var.name}{Name of output variable; must appear in df}

\item{firm.var.name}{Name of firm variable; must appear in df}

\item{time.var.name}{Name of time variable; must appear in df}

\item{method}{Constraints to apply; "u" for unconstrained, "m" for monotonically increasing, and "mc" for monotonically increasing and concave}
}
\value{
Returns a data.frame with the following columns
\item{firm.var.name}{Column of firm name data}
\item{time.var.name}{Column of time period data}
\item{efficiency.change}{Average annual efficiency change since the previous period in data}
\item{technical.change}{Average annual technical change since the previous period in data}
\item{productivity.change}{Average annual productivity change since the previous period in data}
}
\description{
Estimates technical and efficiency change using SNFA
}
\details{
This function decomposes change in productivity into efficiency and technical change, as in
Fare et al. (1994), using smooth non-parametric frontier analysis. Denoting \eqn{D_s(x_t, y_t)}
as the efficiency of the production plan in year t relative to the production frontier in year s,
efficiency change for a given firm in year t is calculated as

\deqn{\frac{D_{t+1}(x_{t+1}, y_{t+1})}{D_t(x_t, y_t)},}

and technical change is given by

\deqn{\left(
\frac{D_t(x_{t+1}, y_{t+1})}{D_{t+1}(x_{t+1}, y_{t+1})}\times
\frac{D_t(x_t, y_t)}{D_{t+1}(x_t, y_t)}
\right)^{1/2}.}
}
\examples{
data(panel.production)

results.df <- technical.efficiency.change(df = panel.production,
                                          input.var.names = c("X.1", "X.2", "X.3"),
                                          output.var.name = "y",
                                          firm.var.name = "Firm",
                                          time.var.name = "Year")

#Plot changes over time by firm
library(ggplot2)

ggplot(results.df, aes(Year, technical.change)) +
  geom_line(aes(color = Firm))
ggplot(results.df, aes(Year, efficiency.change)) +
  geom_line(aes(color = Firm))
ggplot(results.df, aes(Year, productivity.change)) +
  geom_line(aes(color = Firm))
  
}
\references{
\insertRef{Fare}{snfa}
}
