% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snotel_download.r
\name{snotel_download}
\alias{snotel_download}
\title{Dowloads snotel data based upon a subset of the
sno-tel info as provided by snotel_info()}
\usage{
snotel_download(
  site_id,
  network = "sntl",
  path = tempdir(),
  metric = TRUE,
  internal = FALSE
)
}
\arguments{
\item{site_id}{subset of the sites listed by snotel_info()}

\item{network}{network list to query (default = sntl, for SNOTEL)}

\item{path}{where to save downloaded files (default = tempdir())}

\item{metric}{return metric values, \code{TRUE} or \code{FALSE}
(default = \code{TRUE}), when false returns the raw data files}

\item{internal}{return data to workspace, \code{TRUE} or \code{FALSE}
(default = \code{FALSE})}
}
\description{
Dowloads snotel data based upon a subset of the
sno-tel info as provided by snotel_info()
}
\examples{

\dontrun{
# download data for SNOTEL site 429 and 1287, returning data to 
# the R workspace
df <- snotel_download(site_id = c(429,1287), internal = TRUE)

# list a few first rows
head(df)
}
}
