% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tools.r
\name{mca.eigen.check}
\alias{mca.eigen.check}
\title{MCA Eigenvalue check}
\usage{
mca.eigen.check(x, passive = "Missing")
}
\arguments{
\item{x}{a data.frame of factors or a result object from soc.mca}

\item{passive}{a character vector with the full or partial names of categories to be set as passive. Each element in passive is passed to a grep function.}
}
\value{
a tibble
}
\description{
Two variables that have perfectly or almost perfectly overlapping sets of categories will skew an mca analysis. This function tries to find the variables that do that so that we may remove them from the analysis or set some of the categories as passive.
An MCA is run on all pairs of variables in the active dataset and we take first and strongest eigenvalue for each pair.
Values range from 0.5 to 1, where 1 signifies a perfect or near perfect overlap between sets of categories while 0.5 is the opposite - a near orthogonal relationship between the two variables.
While a eigenvalue of 1 is a strong candidate for intervention, probably exclusion of one of the variables, it is less clear what the lower bound is. But values around 0.8 are also strong candidates for further inspection.
}
\examples{
example(soc.mca)
mca.eigen.check(active)
mca.eigen.check(result)
}
