% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logloss}
\alias{logloss}
\title{Computes the log loss score for a tournament prediction}
\usage{
logloss(m, outcome, rankweights = 1L)
}
\arguments{
\item{m}{An R*T prediction matrix where the R rows represent the ordered ranks and each column is a team. Each column should sum to 1, and each row should sum to the number of teams that can attain a given rank.}

\item{outcome}{A vector of length T containing the integers 1 to R giving the ranks that were obtained by each of the T teams}

\item{rankweights}{A vector of length R of rank weights or a single weight which will be reused for all ranks (defaults to 1)}
}
\value{
The rank probability score. Zero means a perfect score.
}
\description{
Compute the (weighted) rank probability score for a tournament.
}
\examples{

m1 <- matrix(c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, .5, .5, 0, 0, .5, .5), 4)
m1 # Prediction where certain on the top ranks
logloss(m1, c(1, 2, 3, 4)) 

}
\author{
Claus Ekstrom <ekstrom@sund.ku.dk>
}
