% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.r
\name{lay_out}
\alias{lay_out}
\title{Arrange ggplot2 plots in an arbitrary grid}
\usage{
lay_out(...)
}
\arguments{
\item{...}{A series lists of of ggplot objects}
}
\value{
A grid of ggplot2 plots
}
\description{
Arrange ggplot2 plots in an arbitrary grid
}
\details{
The function takes arguments of the form `list(plot, row(s),
    column(s))` where `plot` is a ggplot2 plot object, and the
    rows and columns identify an area of the grid that you want
    that plot object to occupy. See
    http://stackoverflow.com/questions/18427455/multiple-ggplots-of-different-sizes
}
\examples{
library(ggplot2)
p1 <- qplot(x=wt,y=mpg,geom="point",main="Scatterplot of wt vs.
    mpg", data=mtcars)
p2 <- qplot(x=wt,y=disp,geom="point",main="Scatterplot of wt vs
    disp", data=mtcars)
p3 <- qplot(wt,data=mtcars)
lay_out(list(p1, 1:2, 1:4),
      list(p2, 3:4, 1:2),
      list(p3, 3:4, 3:4))
}
\author{
Extracted from the [wq] package
}
