% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sofa-package.r
\docType{package}
\name{sofa-package}
\alias{sofa-package}
\alias{sofa}
\title{R client for CouchDB.}
\description{
Relax.
}
\section{About sofa}{

\pkg{sofa} provides an interface to the NoSQL database CouchDB
(\url{http://couchdb.apache.org}). Methods are provided for managing
databases within CouchDB, including creating/deleting/updating/transferring,
and managing documents within databases. One can connect with a local
CouchDB instance, or a remote CouchDB databases such as Cloudant
(\url{https://cloudant.com}). Documents can be inserted directly from
vectors, lists, data.frames, and JSON.
}

\section{Client connections}{

All functions take as their first parameter a client connection object,
or a \strong{cushion}. Create the object with \link{Cushion}. You
can have multiple connection objects in an R session.
}

\section{CouchDB versions}{

\pkg{sofa} was built assuming CouchDB version 2 or greater. Some
functionality of this package will work with versions < 2, while
some may not (mango queries, see \code{\link[=db_query]{db_query()}}). I don't
plan to support older CouchDB versions per se.
}

\section{Digits after the decimal}{

If you have any concern about number of digits after the decimal
in your documents, make sure to look at \code{digits} in your R options.
The default value is 7 (see \link{options} for more informnation). You
can set the value you like with e.g., \code{options(digits = 10)}, and
get what \code{digits} is set to with \code{getOption("digits")}.

Note that in \code{\link[=doc_create]{doc_create()}} we convert your document to JSON with
\code{jsonlite::toJSON()} if given as a list, which has a \code{digits} parameter.
We pass \code{getOption("digits")} to the \code{digits} parameter in
\code{jsonlite::toJSON()}.
}

\section{Defunct functions}{

\itemize{
\item \link{attach_get}
}
}

\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\keyword{package}
