% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchHWSD.R
\name{fetchHWSD}
\alias{fetchHWSD}
\alias{get_HWSD_path}
\title{Fetch Harmonized World Soil Database Data}
\source{
Food and Agriculture Organization of the United Nations (FAO), Soils
Portal, Harmonized World Soil Database (HWSD) v2.0
\url{https://www.fao.org/soils-portal/data-hub/soil-maps-and-databases/harmonized-world-soil-database-v20/en/}
}
\usage{
fetchHWSD(
  x = NULL,
  hwsd_url = "https://s3.eu-west-1.amazonaws.com/data.gaezdev.aws.fao.org/HWSD/",
  hwsd_version = 2L,
  force = FALSE
)

get_HWSD_path(what = c("sqlite", "mdb", "raster", "path"), hwsd_version = 2L)
}
\arguments{
\item{x}{A \emph{SpatRaster}, \emph{SpatVector}, \emph{SpatExtent}, or any other object that has
a \emph{SpatExtent}. Default \code{NULL} returns the full dataset. Extent of interest
that is passed to \code{terra::crop()} \code{y} argument.}

\item{hwsd_url}{\emph{character}. URL for downloading HWSD dataset. Default
\code{"https://s3.eu-west-1.amazonaws.com/data.gaezdev.aws.fao.org/HWSD/"}}

\item{hwsd_version}{\emph{integer}. Default \code{2L}.}

\item{force}{Force rebuilding of cache. Default: \code{FALSE}}

\item{what}{\emph{character}. One of "sqlite", "raster", or "path"}
}
\value{
A \emph{SpatRaster} object with mapunit-level aggregate information stored
as categories.
}
\description{
Creates a local cache of FAO Harmonized World Soil Database (HWSD)
information. Source raster map in ESRI Grid format (.bil) is converted to GeoTIFF.
The source tabular database in Microsoft Access (.mdb) format is converted to SQLite.
}
\examples{
\dontshow{if (requireNamespace("terra", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  x <- terra::vect(system.file("ex", "lux.shp", package = "terra"))
  res <- fetchHWSD(x)
  
  # categorical data (WRB class)
  terra::activeCat(res) <- "WRB4"
  
  # view WRB4 map
  terra::plot(res)
  terra::lines(x, col = "white")
  
  # convert categories containing numeric data to numeric values
  res2 <- terra::catalyze(res)
  
  # view AWC map
  terra::plot(res2$AWC, main = "Available Water Capacity, mm")
  terra::lines(x, col = "white")
  
  # access tabular data from cached SQLite database
  SDA_query("SELECT * FROM HWSD2_SMU LIMIT 1", dsn = get_HWSD_path())
}
\dontshow{\}) # examplesIf}
}
