% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilchemistry.R
\name{Langmuir}
\alias{Langmuir}
\title{Langmuir isotherm fitted to adsorption data}
\usage{
Langmuir(W = W, V = V, Ci = Ci, Cf = Cf,...)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{V}{Volume of extractant solution (mL)}

\item{Ci}{Initial concentration (mg/L) of the added element, e.g., phosphorus}

\item{Cf}{Final or equilibrium concentration (mg/L) after adsorption of the same element}

\item{...}{Any other argument that can be passed to base plot}
}
\value{
b - Maximum monolayer adsorption or adsorption maxima (mg/kg)
k - Constant related to binding energy or the affinity coefficient for the nutrient, e.g., P (L/mg)
MBC - Maximum buffering capacity of soil for the nutrient under consideration (L/kg)
}
\description{
The linear form of Langmuir adsorption isotherm can be fitted to adsorption data to find out adsorption maxima, affinity coefficient, and maximum buffering capacity (Langmuir, 1918).
}
\examples{
with(data = df_sordes, Langmuir(W = 2, V = 20, Ci = Initial_conc, Cf = Equilibrium_conc))
}
\references{
Havlin, J.L., Tisdale, S.L., Nelson, W.L., Beaton, J.D., 2016. Phosphorus. In: Soil fertility and fertilizers. Pearson Education India, pp.160–198.
Holford, I.C.R., Mattingly, G.E.G., 1976. Phosphate adsorption and plant availability of phosphate. Plant and Soil 44, 377–389. https://doi.org/10.1007/BF00015889
Langmuir, I., 1918. The adsorption of gases on plane surfaces of glass, mica, and platinum. Journal of American Chemical Society 40, 1361–1403. https://doi.org/10.1021/ja02242a004
Shirvani, M., Shariatmadari, H., Kalbasi, M., 2005. Phosphorus buffering capacity indices as related to soil properties and plant uptake. Journal of Plant Nutrition, 28, 537–550. https://doi.org/10.1081/PLN-200049235
}
