% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{newnode}
\alias{newnode}
\title{Add node to the community}
\usage{
newnode(COMM, newname, prey = NA, predator = NA, newprops)
}
\arguments{
\item{COMM}{The community to which to add nodes.}

\item{newname}{The new node ID.}

\item{prey}{A vector of prey preferences with names.}

\item{predator}{A vector of predators and their preferences with name.}

\item{newprops}{A vector of the new properties with the appropriate names.}
}
\value{
The community with the new node.
}
\description{
Add node to the community
}
\examples{
# Add a node to the introductory community:
newnode(intro_comm, "NewNode",
prey = c(Detritus1 = 1),
predator = c(Predator = 2, Orib1 = 0.1),
newprops = c(d = 1, a = 0.1, p = 0.1,
B = 10, CN = 10, DetritusRecycling = 0,
isDetritus = 0, isPlant = 0, canIMM = 0))
}
\seealso{
\code{\link{removenodes}}
}
