% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.accuracy.R
\name{som.nn.accuracy}
\alias{som.nn.accuracy}
\title{Calculate accuracy measures}
\usage{
som.nn.accuracy(x, class.labels)
}
\arguments{
\item{x}{\code{data.frame} with the predictions as returned by the
SOM.nn predict method.}

\item{class.labels}{\code{vector} of correct class labels for the predictions.}
}
\value{
\code{data.frame} containing sensitivity, specificity and accuracy for all
class labels in the data set.
}
\description{
Calculates the sensitivity, specificity and overall accuracy for a prediction result
if the corresponding vector of true class labels
is provided.
}
\details{
\strong{Sensitivity} is the classifier's ability to correctly identify samples of a specific class A.
It is defined as

\deqn{sens_{A} = TP_{A} / (TP_{A} + FN_{A})}

with  TP = true positives and FN = false negatives. This is equivalent to the
ratio of (correctly identified samples of class A) / (total number of samples of class A).

\strong{Specificity} is the classifier's ability to correctly identify samples not
of a specific class A.
It is defined as

\deqn{spec_{A} = TN_{A} / (TN_{A} + FP_{A})}

with  TN = true negatives and FP = false positives. This is equivalent to the
ratio of (correctly identified samples not in class A) / (total number of samples not in class A).

\strong{Accuracy} is the classifier's ability to correctly classify samples of
a specific class A.
It is defined as

\deqn{acc_{A} = (TP_{A} + TN_{A}) / total}

with  TP = true positives, TN = true negatives and total = total number of samples of a class.
This is equivalent to the
ratio of (correctly classified samples) / (total number of samples).
}
