% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{AbsorptionAlphaAinslieMcColm}
\alias{AbsorptionAlphaAinslieMcColm}
\title{Calculation of absorption in sea water from Ainslie and McColm 1998}
\source{
National Physical Laboratory, 2015
Calculation of absorption of sound in seawater
\url{http://resource.npl.co.uk/acoustics/techguides/seaabsorption/}
}
\usage{
AbsorptionAlphaAinslieMcColm(f, temperatureC, S, D, pH)
}
\arguments{
\item{f,}{frequency (kHz)}

\item{temperatureC,}{temperature in degrees C}

\item{S,}{salinity in \%}

\item{D,}{depth in meters}

\item{pH,}{pH}
}
\value{
the absorption
}
\description{
Returns the absorption in sea water from Ainslie and McColm 1998
}
\examples{
AbsorptionAlphaAinslieMcColm(20, 0, 30, 0, 7)
}
\author{
Jose Gama
}
\references{
Ainslie and McColm 1998
J. Acoust. Soc. Am., Vol. 103, No. 3
}

