% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concerts.R
\docType{data}
\name{concerts}
\alias{concerts}
\title{Metadata for concerts in the spRingsteen dataset.}
\format{
A data frame with 6 variables:
\describe{
 \item{gig_key}{Primary key of the data frame.}
 \item{date}{Date of the concert.}
 \item{location}{Full location of concert including venue name.}
 \item{state}{State concert was performed in (if in USA).}
 \item{city}{City in which the concert was performed (if not in USA).}
 \item{country}{Country concert was performed in.}
 }
}
\source{
\url{http://brucebase.wikidot.com/}
}
\usage{
concerts
}
\description{
Metadata for concerts played by Bruce Springsteen both solo and
with numerous bands from the years 1973 to present day. Can be joined with
\code{\link{setlists}} using \code{gig_key}.
}
\examples{
library(dplyr)
# What countries have been played in the most?

concerts \%>\%
  count(country, sort = TRUE)

# What decade did most shows take place in?

library(lubridate)

concerts \%>\%
  select(date) \%>\%
  mutate(decade = (year(date) \%/\% 10) * 10) \%>\%
  count(decade)

}
\keyword{datasets}
