% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cylinderFit}
\alias{cylinderFit}
\title{Point cloud cylinder fitting as per de Conto et al. 2017 as implemented here: https://github.com/tiagodc/TreeLS}
\usage{
cylinderFit(
  las,
  method = "ransac",
  n = 5,
  inliers = 0.9,
  conf = 0.95,
  max_angle = 30,
  n_best = 20
)
}
\arguments{
\item{las}{LAS normalized and segmented las object.}

\item{method}{method for estimating the cylinder parameters. Currently available: \code{"nm"}, \code{"irls"}, \code{"ransac"} and \code{"bf"}.}

\item{n}{number of points selected on every RANSAC iteration.}

\item{inliers}{expected proportion of inliers among stem segments' point cloud chunks.}

\item{conf}{confidence level.}

\item{max_angle}{used when \code{method == "bf"}. The maximum tolerated deviation, in degrees, from an absolute vertical line (Z = c(0,0,1)).}

\item{n_best}{estimate optimal RANSAC parameters as the median of the \code{n_best} estimations with lowest error.}
}
\value{
vector of parameters
}
\description{
Fits a cylinder on a set of 3D points.
}
\examples{
\donttest{
# Define the cylinder attributes
npts = 500
cyl_length = 0.5
radius = 0.2718

# Generate the X,Y,Z values
Z=runif(n = npts, min = 0, max = cyl_length)
angs = runif(npts, 0, 2*pi)
X = sin(angs)*radius
Y = cos(angs)*radius

# Creation of a LAS object out of external data
cloud <- LAS(data.frame(X,Y,Z))

# Fit a cylinder and retrun the information
cyl_par = spanner::cylinderFit(cloud, method = 'ransac', n=5, inliers=.9,
                               conf=.95, max_angle=30, n_best=20)
}
}
