% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patch_Morph.R
\name{process_rasters_patchmorph}
\alias{process_rasters_patchmorph}
\title{Process rasters based on suitability, gap, and spur parameters}
\usage{
process_rasters_patchmorph(input_raster, suitList, gapList, spurList)
}
\arguments{
\item{input_raster}{RasterLayer The input raster to be processed.}

\item{suitList}{numeric A vector of suitability levels for reclassification.}

\item{gapList}{numeric A vector of gap distances for processing.}

\item{spurList}{numeric A vector of spur distances for processing.}
}
\value{
list A list of processed rasters with names indicating the suitability, gap, and spur parameters used.
}
\description{
\code{process_rasters_patchmorph} processes an input raster by reclassifying it based on suitability levels,
and then applying gap and spur distance transformations to generate a list of processed rasters.
}
\examples{
\donttest{
# Define input parameters
las <- lidR::readLAS(system.file("extdata", "MixedConifer.laz", package="lidR"))
input_raster <- lidR::rasterize_canopy(las, res = 1, lidR::pitfree(c(0,2,5,10,15), c(0, 2)))
suitList <- c(0, 2, 32)
gapList <- seq(1, 8, by = 1)
spurList <- seq(1, 8, by = 1)

# Process the rasters
processed_rasters <- process_rasters_patchmorph(input_raster, suitList, gapList, spurList)

# Plot the first processed raster
plot(processed_rasters[[1]])
}

}
