% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_f1.R
\name{span_f1}
\alias{span_f1}
\title{F1 Alpha-Spanning Test (Intercepts Only)}
\usage{
span_f1(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times K}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times N}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value for the \eqn{F}-statistic under the null.}
  \item{\code{stat}}{F1 \eqn{F}-statistic.}
  \item{\code{H0}}{Null hypothesis description, \code{"alpha = 0"}.}
}
}
\description{
Tests the null \eqn{H_0:\ \alpha = 0} that the intercepts of the test assets
are jointly zero when regressed on the benchmark assets, i.e., benchmarks
span the mean of the test assets. This is the F1 test of Kan & Zhou (2012).
}
\details{
Under standard assumptions (i.i.d. returns, full-rank covariances), the
reference distribution is \eqn{F_{N,\ T-K-N}}. Finite-sample feasibility
requires \eqn{T-K-N \ge 1}.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, K=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, N=2
out <- span_f1(R1, R2)
out$stat; out$pval; out$H0

}
\references{
\insertRef{KanZhou2012}{spantest}
}
\seealso{
Other Alpha Spanning Tests: 
\code{\link{span_bj}()},
\code{\link{span_gl_a}()},
\code{\link{span_grs}()},
\code{\link{span_py}()}
}
\concept{Alpha Spanning Tests}
