% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_f2.R
\name{span_f2}
\alias{span_f2}
\title{F2 Variance-Spanning Test (Slopes Only)}
\usage{
span_f2(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times K}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times N}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value for the \eqn{F}-statistic under the null.}
  \item{\code{stat}}{F2 \eqn{F}-statistic.}
  \item{\code{H0}}{Null hypothesis description, \code{"delta = 0"}.}
}
}
\description{
Tests the null \eqn{H_0:\ \delta = 0} that adding test assets does not
improve the minimum-variance frontier spanned by the benchmarks (variance
spanning). The statistic compares frontier-defining quantities of the
augmented (benchmark + test) universe to those of the benchmark subset.
}
\details{
Under standard conditions (i.i.d. returns, full-rank covariances), the reference
distribution is \eqn{F_{N,\ T-K-N+1}}. Finite-sample feasibility requires
\eqn{T-K-N+1 \ge 1}.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, K=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, N=2
out <- span_f2(R1, R2)
out$stat; out$pval; out$H0

}
\references{
\insertRef{KanZhou2012}{spantest}
}
\seealso{
Other Variance Spanning Tests: 
\code{\link{span_km}()}
}
\concept{Variance Spanning Tests}
