% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_join.R
\name{join.tbl_spark}
\alias{join.tbl_spark}
\alias{inner_join.tbl_spark}
\alias{left_join.tbl_spark}
\alias{right_join.tbl_spark}
\alias{full_join.tbl_spark}
\title{Join Spark tbls.}
\usage{
\method{inner_join}{tbl_spark}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c("_x", "_y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{left_join}{tbl_spark}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c("_x", "_y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{right_join}{tbl_spark}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c("_x", "_y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{full_join}{tbl_spark}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c("_x", "_y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)
}
\arguments{
\item{x, y}{A pair of lazy data frames backed by database queries.}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into a
temporary table in same database as \code{x}. \verb{*_join()} will automatically
run \code{ANALYZE} on the created table in the hope that this will make
you queries as efficient as possible by giving more data to the query
planner.

This allows you to join tables across srcs, but it's potentially expensive
operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{auto_index}{if \code{copy} is \code{TRUE}, automatically create
indices for the variables in \code{by}. This may speed up the join if
there are matching indexes in \code{x}.}

\item{...}{Other parameters passed onto methods.}

\item{sql_on}{A custom join predicate as an SQL expression.
Usually joins use column equality, but you can perform more complex
queries by supply \code{sql_on} which should be a SQL expression that
uses \code{LHS} and \code{RHS} aliases to refer to the left-hand side or
right-hand side of the join respectively.}
}
\description{
These functions are wrappers around their `dplyr` equivalents that set
Spark SQL-compliant values for the `suffix` argument by replacing dots (`.`)
with underscores (`_`). See [join] for a description of the general purpose
of the functions.
}
