% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coef.sparselink}
\alias{coef.sparselink}
\title{Regression Coefficients}
\usage{
\method{coef}{sparselink}(object, ...)
}
\arguments{
\item{object}{object of class \code{"sparselink"}
(generated by function \link{sparselink})}

\item{...}{(not applicable)}
}
\value{
Returns estimated coefficients.
The output is a list with two slots:
slot \code{alpha} with the estimated intercept
(vector of length \eqn{q}),
and slot \code{beta} with the estimated slopes
(matrix with \eqn{p} rows and \eqn{q} columns).
}
\description{
Extracts coefficients from multi-task or transfer learning regression model.
}
\examples{
family <- "gaussian"
type <- "multiple" #  try "multiple" or "transfer"
if(type=="multiple"){
 data <- sim_data_multi(family=family)
} else if(type=="transfer"){
 data <- sim_data_trans(family=family)
}
\dontshow{data <- sim_data_trans(family=family,n0=10,p=3)}
object <- sparselink(x=data$X_train,y=data$y_train,family=family)
coef <- coef(object=object)

}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0003-3443-0298}{Petr N. Nazarov}, and
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab}
(2025).
"Estimating sparse regression models in multi-task learning and transfer learning through adaptive penalisation".
\emph{Under revision}. \url{https://hdl.handle.net/10993/63425}
}
\seealso{
Use \code{\link{sparselink}} to fit the model
and \code{\link[=predict.sparselink]{predict}} to make predictions.
}
