% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_vertices.R
\name{extract.vertices}
\alias{extract.vertices}
\title{Extract vertices for polygons or lines}
\usage{
extract.vertices(x, join = TRUE)
}
\arguments{
\item{x}{An sf line or polygon class object}

\item{join}{(TRUE/FALSE) Joint attributes from original object}
}
\value{
An sf POINT object of extrated line or polygon vertices
}
\description{
Extracts [x,y] vertices from an sf line or polygon object
}
\details{
This function returns the vertices of a line or polygon object, as opposed
to the polygon centroids or line start/stop coordinates
}
\examples{

library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
  nc <- suppressWarnings(sf::st_cast(nc, "POLYGON"))
    nc <- nc[c(10,50),]
  
( v <- extract.vertices(nc) )
  plot(st_geometry(nc))
    plot(st_geometry(v), pch=20, cex=2, col="red", add=TRUE)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
