% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_extent.R
\name{max_extent}
\alias{max_extent}
\title{Maximum extent of multiple rasters}
\usage{
max_extent(x, ...)
}
\arguments{
\item{x}{terra SpatRaster class object}

\item{...}{additional SpatRaster class objects in same projection}
}
\value{
An sf POLYGON class object representing maximum extents
}
\description{
returns a extent polygon representing maximum extent of
             input rasters
}
\details{
Creates a maximum extent polygon of all specified rasters
}
\examples{
library(terra)

r1 <- rast(ext(61.87125, 76.64458, 23.90153, 37.27042))
r2 <- rast(ext(67.66625, 81.56847, 20.38458, 35.67347))
r3 <- rast(ext(72.64792,84.38125,5.91125,28.13347 ))

( e <- max_extent(r1, r2, r3) )
plot(e, border=NA)
  plot(ext(r1), border="red", add=TRUE)
  plot(ext(r2), border="green", add=TRUE)
  plot(ext(r3), border="blue", add=TRUE)
  plot(e, border="black", add=TRUE)
		    
 sf::st_bbox(e) # full extent

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
